using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using devDept.Eyeshot;
using devDept.Eyeshot.Labels;
using devDept.Geometry;
using devDept.Graphics;
using devDept.Eyeshot.Entities;

namespace WpfApplication1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow
    {
        public MainWindow()
        {
            InitializeComponent();            

            // https://msdn.microsoft.com/en-us/library/dd901337(v=vs.90).aspx                  
            devDept.Eyeshot.Environment.DisableWpfTabletSupport(); // commenting this line, WM_TOUCH will not work anymore.
        }

        private Model model1;                
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (model1 != null) return;

            model1 = new Model();
            // model1.Unlock(""); // For more details see 'Product Activation' topic in the documentation.

            model1.Renderer = rendererType.Native; // or rendererType.NativeExperimental
            model1.MultiTouch.UseWindowsMessages = true; // enables WM_TOUCH           

            model1.ShowFps = true;            
            model1.InitializeScene += Model1_InitializeScene;            

            model1.InitializeViewports();
            var viewport = model1.ActiveViewport;
            viewport.ToolBars.Add(devDept.Eyeshot.ToolBar.GetDefaultToolBar());
            viewport.ViewCubeIcon = ViewCubeIcon.GetDefaultViewCubeIcon();
            viewport.CoordinateSystemIcon = CoordinateSystemIcon.GetDefaultCoordinateSystemIcon();

            // Adds the Model programmatically
            MainPanel.Children.Add(model1);                               
        }

        private void Model1_InitializeScene(object sender, EventArgs e)
        {            
            model1.Entities.Add(Mesh.CreateBox(5, 5, 5), System.Drawing.Color.Blue);         
            model1.SetView(viewType.Trimetric);
            model1.ZoomFit();            
            model1.Invalidate();
        }
    }
}